<?php
/*
Plugin Name: UTM Link Builder Pro
Description: Generator linków UTM w panelu i przez shortcode.
Version: 1.1
Author: ChatGPT
*/

if (!defined('ABSPATH')) exit;

// Admin menu
add_action('admin_menu', function() {
    add_menu_page(
        'UTM Builder',
        'UTM Builder',
        'manage_options',
        'utm-builder',
        'utm_builder_admin_page'
    );
});

function utm_builder_admin_page() {
    ?>
    <div class="wrap">
        <h2>Generator UTM</h2>
        <p>Wypełnij pola, aby wygenerować link z parametrami UTM.</p>

        <form id="utm-builder-form-admin">
            <input type="text" id="utm-url" placeholder="URL" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-source" placeholder="utm_source" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-medium" placeholder="utm_medium" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-campaign" placeholder="utm_campaign" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-content" placeholder="utm_content" style="width:100%;margin-bottom:10px;">
            <button type="button" id="utm-generate">Generuj link</button>
        </form>

        <h3>Wynik:</h3>
        <input type="text" id="utm-result" style="width:100%;margin-top:10px;">
    </div>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        document.getElementById("utm-generate").addEventListener("click", function() {
            const url = document.getElementById("utm-url").value;
            const source = document.getElementById("utm-source").value;
            const medium = document.getElementById("utm-medium").value;
            const campaign = document.getElementById("utm-campaign").value;
            const content = document.getElementById("utm-content").value;

            if (!url) { alert("Podaj URL!"); return; }

            const params = new URLSearchParams();
            if (source) params.append("utm_source", source);
            if (medium) params.append("utm_medium", medium);
            if (campaign) params.append("utm_campaign", campaign);
            if (content) params.append("utm_content", content);

            document.getElementById("utm-result").value =
                url + (url.includes("?") ? "&" : "?") + params.toString();
        });
    });
    </script>
    <?php
}

// Shortcode
function utm_builder_shortcode() {
    ob_start();
    ?>
    <div class="utm-builder-container" style="max-width:500px;padding:20px;background:#f9f9f9;border:1px solid #ddd;border-radius:8px;">
        <h3>Generator linków UTM</h3>
        <form id="utm-builder-form">
            <input type="text" id="utm-url" placeholder="URL" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-source" placeholder="utm_source" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-medium" placeholder="utm_medium" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-campaign" placeholder="utm_campaign" style="width:100%;margin-bottom:10px;">
            <input type="text" id="utm-content" placeholder="utm_content" style="width:100%;margin-bottom:10px;">
            <button type="button" id="utm-generate-sc">Generuj link</button>
        </form>

        <h4>Twój link:</h4>
        <input type="text" id="utm-result-sc" style="width:100%;padding:8px;">
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const btn = document.getElementById("utm-generate-sc");
            btn?.addEventListener("click", function() {
                const url = document.getElementById("utm-url").value;
                const source = document.getElementById("utm-source").value;
                const medium = document.getElementById("utm-medium").value;
                const campaign = document.getElementById("utm-campaign").value;
                const content = document.getElementById("utm-content").value;

                if (!url) { alert("Podaj URL!"); return; }

                const params = new URLSearchParams();
                if (source) params.append("utm_source", source);
                if (medium) params.append("utm_medium", medium);
                if (campaign) params.append("utm_campaign", campaign);
                if (content) params.append("utm_content", content);

                document.getElementById("utm-result-sc").value =
                    url + (url.includes("?") ? "&" : "?") + params.toString();
            });
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('utm_builder', 'utm_builder_shortcode');
?>
